/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharByteShortTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterReinterpretedBooleanShortColumnTupleSource
extends AbstractTupleSource<CharByteShortTuple> {
    public static final ThreeColumnTupleSourceFactory<CharByteShortTuple, Character, Byte, Short> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Short> columnSource3;

    public CharacterReinterpretedBooleanShortColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final CharByteShortTuple createTuple(long rowKey) {
        return new CharByteShortTuple(this.columnSource1.getChar(rowKey), this.columnSource2.getByte(rowKey), this.columnSource3.getShort(rowKey));
    }

    public final CharByteShortTuple createPreviousTuple(long rowKey) {
        return new CharByteShortTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrevByte(rowKey), this.columnSource3.getPrevShort(rowKey));
    }

    public final CharByteShortTuple createTupleFromValues(Object ... values) {
        return new CharByteShortTuple(TypeUtils.unbox((Character)((Character)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final CharByteShortTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharByteShortTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharByteShortTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharByteShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharByteShortTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharByteShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull CharByteShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharByteShortTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharByteShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ShortChunk chunk3 = chunks[2].asShortChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharByteShortTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<CharByteShortTuple, Character, Byte, Short> {
        private Factory() {
        }

        @Override
        public TupleSource<CharByteShortTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
            return new CharacterReinterpretedBooleanShortColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

