/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleBooleanColumnTupleSource
extends AbstractTupleSource<DoubleByteTuple> {
    public static final TwoColumnTupleSourceFactory<DoubleByteTuple, Double, Boolean> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Boolean> columnSource2;

    public DoubleBooleanColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Boolean> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final DoubleByteTuple createTuple(long rowKey) {
        return new DoubleByteTuple(this.columnSource1.getDouble(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getBoolean(rowKey)));
    }

    public final DoubleByteTuple createPreviousTuple(long rowKey) {
        return new DoubleByteTuple(this.columnSource1.getPrevDouble(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getPrevBoolean(rowKey)));
    }

    public final DoubleByteTuple createTupleFromValues(Object ... values) {
        return new DoubleByteTuple(TypeUtils.unbox((Double)((Double)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])));
    }

    public final DoubleByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleByteTuple(TypeUtils.unbox((Double)((Double)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleByteTuple(chunk1.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk2.get(ii)))));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<DoubleByteTuple, Double, Boolean> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleByteTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Boolean> columnSource2) {
            return new DoubleBooleanColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

