/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleByteObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleByteObjectColumnTupleSource
extends AbstractTupleSource<DoubleByteObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleByteObjectTuple, Double, Byte, Object> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public DoubleByteObjectColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleByteObjectTuple createTuple(long rowKey) {
        return new DoubleByteObjectTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getByte(rowKey), this.columnSource3.get(rowKey));
    }

    public final DoubleByteObjectTuple createPreviousTuple(long rowKey) {
        return new DoubleByteObjectTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevByte(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final DoubleByteObjectTuple createTupleFromValues(Object ... values) {
        return new DoubleByteObjectTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), values[2]);
    }

    public final DoubleByteObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleByteObjectTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleByteObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteObjectTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull DoubleByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteObjectTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleByteObjectTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleByteObjectTuple, Double, Byte, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleByteObjectTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new DoubleByteObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

