/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleCharFloatTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleCharacterFloatColumnTupleSource
extends AbstractTupleSource<DoubleCharFloatTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleCharFloatTuple, Double, Character, Float> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Float> columnSource3;

    public DoubleCharacterFloatColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleCharFloatTuple createTuple(long rowKey) {
        return new DoubleCharFloatTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getChar(rowKey), this.columnSource3.getFloat(rowKey));
    }

    public final DoubleCharFloatTuple createPreviousTuple(long rowKey) {
        return new DoubleCharFloatTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrevFloat(rowKey));
    }

    public final DoubleCharFloatTuple createTupleFromValues(Object ... values) {
        return new DoubleCharFloatTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final DoubleCharFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleCharFloatTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleCharFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleCharFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleCharFloatTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleCharFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleCharFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleCharFloatTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleCharFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        FloatChunk chunk3 = chunks[2].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleCharFloatTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleCharFloatTuple, Double, Character, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleCharFloatTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
            return new DoubleCharacterFloatColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

