/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleDoubleColumnTupleSource
extends AbstractTupleSource<DoubleDoubleTuple> {
    public static final TwoColumnTupleSourceFactory<DoubleDoubleTuple, Double, Double> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Double> columnSource2;

    public DoubleDoubleColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final DoubleDoubleTuple createTuple(long rowKey) {
        return new DoubleDoubleTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getDouble(rowKey));
    }

    public final DoubleDoubleTuple createPreviousTuple(long rowKey) {
        return new DoubleDoubleTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevDouble(rowKey));
    }

    public final DoubleDoubleTuple createTupleFromValues(Object ... values) {
        return new DoubleDoubleTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final DoubleDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleDoubleTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleDoubleTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleDoubleTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleDoubleTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<DoubleDoubleTuple, Double, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleDoubleTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
            return new DoubleDoubleColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

