/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleFloatTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleFloatColumnTupleSource
extends AbstractTupleSource<DoubleFloatTuple> {
    public static final TwoColumnTupleSourceFactory<DoubleFloatTuple, Double, Float> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Float> columnSource2;

    public DoubleFloatColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Float> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final DoubleFloatTuple createTuple(long rowKey) {
        return new DoubleFloatTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getFloat(rowKey));
    }

    public final DoubleFloatTuple createPreviousTuple(long rowKey) {
        return new DoubleFloatTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevFloat(rowKey));
    }

    public final DoubleFloatTuple createTupleFromValues(Object ... values) {
        return new DoubleFloatTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Float)((Float)values[1])));
    }

    public final DoubleFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleFloatTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Float)((Float)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleFloatTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        FloatChunk chunk2 = chunks[1].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleFloatTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleFloatTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<DoubleFloatTuple, Double, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleFloatTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Float> columnSource2) {
            return new DoubleFloatColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

