/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleFloatLongTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleFloatLongColumnTupleSource
extends AbstractTupleSource<DoubleFloatLongTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleFloatLongTuple, Double, Float, Long> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Float> columnSource2;
    private final ColumnSource<Long> columnSource3;

    public DoubleFloatLongColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Float> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleFloatLongTuple createTuple(long rowKey) {
        return new DoubleFloatLongTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getFloat(rowKey), this.columnSource3.getLong(rowKey));
    }

    public final DoubleFloatLongTuple createPreviousTuple(long rowKey) {
        return new DoubleFloatLongTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevFloat(rowKey), this.columnSource3.getPrevLong(rowKey));
    }

    public final DoubleFloatLongTuple createTupleFromValues(Object ... values) {
        return new DoubleFloatLongTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Float)((Float)values[1])), TypeUtils.unbox((Long)((Long)values[2])));
    }

    public final DoubleFloatLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleFloatLongTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Float)((Float)values[1])), TypeUtils.unbox((Long)((Long)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleFloatLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleFloatLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleFloatLongTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
        dest[2] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleFloatLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleFloatLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleFloatLongTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
        dest[2] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleFloatLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        FloatChunk chunk2 = chunks[1].asFloatChunk();
        LongChunk chunk3 = chunks[2].asLongChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleFloatLongTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleFloatLongTuple, Double, Float, Long> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleFloatLongTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Float> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
            return new DoubleFloatLongColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

