/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleIntTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleIntegerColumnTupleSource
extends AbstractTupleSource<DoubleIntTuple> {
    public static final TwoColumnTupleSourceFactory<DoubleIntTuple, Double, Integer> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Integer> columnSource2;

    public DoubleIntegerColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final DoubleIntTuple createTuple(long rowKey) {
        return new DoubleIntTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getInt(rowKey));
    }

    public final DoubleIntTuple createPreviousTuple(long rowKey) {
        return new DoubleIntTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevInt(rowKey));
    }

    public final DoubleIntTuple createTupleFromValues(Object ... values) {
        return new DoubleIntTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final DoubleIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleIntTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleIntTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleIntTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleIntTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<DoubleIntTuple, Double, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleIntTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
            return new DoubleIntegerColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

