/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleIntShortTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleIntegerShortColumnTupleSource
extends AbstractTupleSource<DoubleIntShortTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleIntShortTuple, Double, Integer, Short> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Short> columnSource3;

    public DoubleIntegerShortColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleIntShortTuple createTuple(long rowKey) {
        return new DoubleIntShortTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.getShort(rowKey));
    }

    public final DoubleIntShortTuple createPreviousTuple(long rowKey) {
        return new DoubleIntShortTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrevShort(rowKey));
    }

    public final DoubleIntShortTuple createTupleFromValues(Object ... values) {
        return new DoubleIntShortTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final DoubleIntShortTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleIntShortTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleIntShortTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleIntShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleIntShortTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleIntShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleIntShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleIntShortTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleIntShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        ShortChunk chunk3 = chunks[2].asShortChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleIntShortTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleIntShortTuple, Double, Integer, Short> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleIntShortTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
            return new DoubleIntegerShortColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

