/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleByteByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleReinterpretedBooleanBooleanColumnTupleSource
extends AbstractTupleSource<DoubleByteByteTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleByteByteTuple, Double, Byte, Boolean> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Boolean> columnSource3;

    public DoubleReinterpretedBooleanBooleanColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleByteByteTuple createTuple(long rowKey) {
        return new DoubleByteByteTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getBoolean(rowKey)));
    }

    public final DoubleByteByteTuple createPreviousTuple(long rowKey) {
        return new DoubleByteByteTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getPrevBoolean(rowKey)));
    }

    public final DoubleByteByteTuple createTupleFromValues(Object ... values) {
        return new DoubleByteByteTuple(TypeUtils.unbox((Double)((Double)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final DoubleByteByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleByteByteTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleByteByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleByteByteTuple(chunk1.get(ii), chunk2.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleByteByteTuple, Double, Byte, Boolean> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleByteByteTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
            return new DoubleReinterpretedBooleanBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

