/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.DoubleShortByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleShortReinterpretedBooleanColumnTupleSource
extends AbstractTupleSource<DoubleShortByteTuple> {
    public static final ThreeColumnTupleSourceFactory<DoubleShortByteTuple, Double, Short, Byte> FACTORY = new Factory();
    private final ColumnSource<Double> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Byte> columnSource3;

    public DoubleShortReinterpretedBooleanColumnTupleSource(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final DoubleShortByteTuple createTuple(long rowKey) {
        return new DoubleShortByteTuple(this.columnSource1.getDouble(rowKey), this.columnSource2.getShort(rowKey), this.columnSource3.getByte(rowKey));
    }

    public final DoubleShortByteTuple createPreviousTuple(long rowKey) {
        return new DoubleShortByteTuple(this.columnSource1.getPrevDouble(rowKey), this.columnSource2.getPrevShort(rowKey), this.columnSource3.getPrevByte(rowKey));
    }

    public final DoubleShortByteTuple createTupleFromValues(Object ... values) {
        return new DoubleShortByteTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Short)((Short)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final DoubleShortByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new DoubleShortByteTuple(TypeUtils.unbox((Double)((Double)values[0])), TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull DoubleShortByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull DoubleShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleShortByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull DoubleShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull DoubleShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((double)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleShortByteTuple tuple) {
        dest[0] = TypeUtils.box((double)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull DoubleShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((double)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        DoubleChunk chunk1 = chunks[0].asDoubleChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        ByteChunk chunk3 = chunks[2].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new DoubleShortByteTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<DoubleShortByteTuple, Double, Short, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<DoubleShortByteTuple> create(@NotNull ColumnSource<Double> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
            return new DoubleShortReinterpretedBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

