/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.FloatByteTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class FloatByteColumnTupleSource
extends AbstractTupleSource<FloatByteTuple> {
    public static final TwoColumnTupleSourceFactory<FloatByteTuple, Float, Byte> FACTORY = new Factory();
    private final ColumnSource<Float> columnSource1;
    private final ColumnSource<Byte> columnSource2;

    public FloatByteColumnTupleSource(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Byte> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final FloatByteTuple createTuple(long rowKey) {
        return new FloatByteTuple(this.columnSource1.getFloat(rowKey), this.columnSource2.getByte(rowKey));
    }

    public final FloatByteTuple createPreviousTuple(long rowKey) {
        return new FloatByteTuple(this.columnSource1.getPrevFloat(rowKey), this.columnSource2.getPrevByte(rowKey));
    }

    public final FloatByteTuple createTupleFromValues(Object ... values) {
        return new FloatByteTuple(TypeUtils.unbox((Float)((Float)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])));
    }

    public final FloatByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new FloatByteTuple(TypeUtils.unbox((Float)((Float)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull FloatByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull FloatByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatByteTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull FloatByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        FloatChunk chunk1 = chunks[0].asFloatChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new FloatByteTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatByteTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<FloatByteTuple, Float, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<FloatByteTuple> create(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Byte> columnSource2) {
            return new FloatByteColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

