/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.FloatLongLongTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class FloatInstantInstantColumnTupleSource
extends AbstractTupleSource<FloatLongLongTuple> {
    public static final ThreeColumnTupleSourceFactory<FloatLongLongTuple, Float, Instant, Instant> FACTORY = new Factory();
    private final ColumnSource<Float> columnSource1;
    private final ColumnSource<Instant> columnSource2;
    private final ColumnSource<Instant> columnSource3;

    public FloatInstantInstantColumnTupleSource(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final FloatLongLongTuple createTuple(long rowKey) {
        return new FloatLongLongTuple(this.columnSource1.getFloat(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.get(rowKey))), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.get(rowKey))));
    }

    public final FloatLongLongTuple createPreviousTuple(long rowKey) {
        return new FloatLongLongTuple(this.columnSource1.getPrevFloat(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.getPrev(rowKey))), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.getPrev(rowKey))));
    }

    public final FloatLongLongTuple createTupleFromValues(Object ... values) {
        return new FloatLongLongTuple(TypeUtils.unbox((Float)((Float)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final FloatLongLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new FloatLongLongTuple(TypeUtils.unbox((Float)((Float)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull FloatLongLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull FloatLongLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongLongTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull FloatLongLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongLongTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        FloatChunk chunk1 = chunks[0].asFloatChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new FloatLongLongTuple(chunk1.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk2.get(ii))), DateTimeUtils.epochNanos((Instant)((Instant)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<FloatLongLongTuple, Float, Instant, Instant> {
        private Factory() {
        }

        @Override
        public TupleSource<FloatLongLongTuple> create(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
            return new FloatInstantInstantColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

