/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.FloatLongIntTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class FloatInstantIntegerColumnTupleSource
extends AbstractTupleSource<FloatLongIntTuple> {
    public static final ThreeColumnTupleSourceFactory<FloatLongIntTuple, Float, Instant, Integer> FACTORY = new Factory();
    private final ColumnSource<Float> columnSource1;
    private final ColumnSource<Instant> columnSource2;
    private final ColumnSource<Integer> columnSource3;

    public FloatInstantIntegerColumnTupleSource(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final FloatLongIntTuple createTuple(long rowKey) {
        return new FloatLongIntTuple(this.columnSource1.getFloat(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.get(rowKey))), this.columnSource3.getInt(rowKey));
    }

    public final FloatLongIntTuple createPreviousTuple(long rowKey) {
        return new FloatLongIntTuple(this.columnSource1.getPrevFloat(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.getPrev(rowKey))), this.columnSource3.getPrevInt(rowKey));
    }

    public final FloatLongIntTuple createTupleFromValues(Object ... values) {
        return new FloatLongIntTuple(TypeUtils.unbox((Float)((Float)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final FloatLongIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new FloatLongIntTuple(TypeUtils.unbox((Float)((Float)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull FloatLongIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull FloatLongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongIntTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull FloatLongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongIntTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        FloatChunk chunk1 = chunks[0].asFloatChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        IntChunk chunk3 = chunks[2].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new FloatLongIntTuple(chunk1.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<FloatLongIntTuple, Float, Instant, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<FloatLongIntTuple> create(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
            return new FloatInstantIntegerColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

