/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.FloatLongTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class FloatLongColumnTupleSource
extends AbstractTupleSource<FloatLongTuple> {
    public static final TwoColumnTupleSourceFactory<FloatLongTuple, Float, Long> FACTORY = new Factory();
    private final ColumnSource<Float> columnSource1;
    private final ColumnSource<Long> columnSource2;

    public FloatLongColumnTupleSource(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Long> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final FloatLongTuple createTuple(long rowKey) {
        return new FloatLongTuple(this.columnSource1.getFloat(rowKey), this.columnSource2.getLong(rowKey));
    }

    public final FloatLongTuple createPreviousTuple(long rowKey) {
        return new FloatLongTuple(this.columnSource1.getPrevFloat(rowKey), this.columnSource2.getPrevLong(rowKey));
    }

    public final FloatLongTuple createTupleFromValues(Object ... values) {
        return new FloatLongTuple(TypeUtils.unbox((Float)((Float)values[0])), TypeUtils.unbox((Long)((Long)values[1])));
    }

    public final FloatLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new FloatLongTuple(TypeUtils.unbox((Float)((Float)values[0])), TypeUtils.unbox((Long)((Long)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull FloatLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull FloatLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull FloatLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull FloatLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((float)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        FloatChunk chunk1 = chunks[0].asFloatChunk();
        LongChunk chunk2 = chunks[1].asLongChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new FloatLongTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongTuple tuple) {
        dest[0] = TypeUtils.box((float)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull FloatLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((float)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<FloatLongTuple, Float, Long> {
        private Factory() {
        }

        @Override
        public TupleSource<FloatLongTuple> create(@NotNull ColumnSource<Float> columnSource1, @NotNull ColumnSource<Long> columnSource2) {
            return new FloatLongColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

