/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntByteCharTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerByteCharacterColumnTupleSource
extends AbstractTupleSource<IntByteCharTuple> {
    public static final ThreeColumnTupleSourceFactory<IntByteCharTuple, Integer, Byte, Character> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public IntegerByteCharacterColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final IntByteCharTuple createTuple(long rowKey) {
        return new IntByteCharTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getByte(rowKey), this.columnSource3.getChar(rowKey));
    }

    public final IntByteCharTuple createPreviousTuple(long rowKey) {
        return new IntByteCharTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevByte(rowKey), this.columnSource3.getPrevChar(rowKey));
    }

    public final IntByteCharTuple createTupleFromValues(Object ... values) {
        return new IntByteCharTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final IntByteCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntByteCharTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntByteCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntByteCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntByteCharTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntByteCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntByteCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntByteCharTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntByteCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntByteCharTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<IntByteCharTuple, Integer, Byte, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<IntByteCharTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new IntegerByteCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

