/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntByteByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerByteReinterpretedBooleanColumnTupleSource
extends AbstractTupleSource<IntByteByteTuple> {
    public static final ThreeColumnTupleSourceFactory<IntByteByteTuple, Integer, Byte, Byte> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Byte> columnSource3;

    public IntegerByteReinterpretedBooleanColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final IntByteByteTuple createTuple(long rowKey) {
        return new IntByteByteTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getByte(rowKey), this.columnSource3.getByte(rowKey));
    }

    public final IntByteByteTuple createPreviousTuple(long rowKey) {
        return new IntByteByteTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevByte(rowKey), this.columnSource3.getPrevByte(rowKey));
    }

    public final IntByteByteTuple createTupleFromValues(Object ... values) {
        return new IntByteByteTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final IntByteByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntByteByteTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])), TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntByteByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntByteByteTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntByteByteTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ByteChunk chunk3 = chunks[2].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntByteByteTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<IntByteByteTuple, Integer, Byte, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<IntByteByteTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
            return new IntegerByteReinterpretedBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

