/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntCharTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerCharacterColumnTupleSource
extends AbstractTupleSource<IntCharTuple> {
    public static final TwoColumnTupleSourceFactory<IntCharTuple, Integer, Character> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Character> columnSource2;

    public IntegerCharacterColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Character> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final IntCharTuple createTuple(long rowKey) {
        return new IntCharTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getChar(rowKey));
    }

    public final IntCharTuple createPreviousTuple(long rowKey) {
        return new IntCharTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevChar(rowKey));
    }

    public final IntCharTuple createTupleFromValues(Object ... values) {
        return new IntCharTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Character)((Character)values[1])));
    }

    public final IntCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntCharTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Character)((Character)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntCharTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntCharTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntCharTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<IntCharTuple, Integer, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<IntCharTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Character> columnSource2) {
            return new IntegerCharacterColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

