/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntFloatTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerFloatColumnTupleSource
extends AbstractTupleSource<IntFloatTuple> {
    public static final TwoColumnTupleSourceFactory<IntFloatTuple, Integer, Float> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Float> columnSource2;

    public IntegerFloatColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Float> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final IntFloatTuple createTuple(long rowKey) {
        return new IntFloatTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getFloat(rowKey));
    }

    public final IntFloatTuple createPreviousTuple(long rowKey) {
        return new IntFloatTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevFloat(rowKey));
    }

    public final IntFloatTuple createTupleFromValues(Object ... values) {
        return new IntFloatTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Float)((Float)values[1])));
    }

    public final IntFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntFloatTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Float)((Float)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntFloatTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        FloatChunk chunk2 = chunks[1].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntFloatTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntFloatTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<IntFloatTuple, Integer, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<IntFloatTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Float> columnSource2) {
            return new IntegerFloatColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

