/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntIntFloatTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerIntegerFloatColumnTupleSource
extends AbstractTupleSource<IntIntFloatTuple> {
    public static final ThreeColumnTupleSourceFactory<IntIntFloatTuple, Integer, Integer, Float> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Float> columnSource3;

    public IntegerIntegerFloatColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final IntIntFloatTuple createTuple(long rowKey) {
        return new IntIntFloatTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.getFloat(rowKey));
    }

    public final IntIntFloatTuple createPreviousTuple(long rowKey) {
        return new IntIntFloatTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrevFloat(rowKey));
    }

    public final IntIntFloatTuple createTupleFromValues(Object ... values) {
        return new IntIntFloatTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final IntIntFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntIntFloatTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntIntFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntIntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntIntFloatTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntIntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntIntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntIntFloatTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntIntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        FloatChunk chunk3 = chunks[2].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntIntFloatTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<IntIntFloatTuple, Integer, Integer, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<IntIntFloatTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
            return new IntegerIntegerFloatColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

