/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntLongObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerLongObjectColumnTupleSource
extends AbstractTupleSource<IntLongObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<IntLongObjectTuple, Integer, Long, Object> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Long> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public IntegerLongObjectColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Long> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final IntLongObjectTuple createTuple(long rowKey) {
        return new IntLongObjectTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getLong(rowKey), this.columnSource3.get(rowKey));
    }

    public final IntLongObjectTuple createPreviousTuple(long rowKey) {
        return new IntLongObjectTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevLong(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final IntLongObjectTuple createTupleFromValues(Object ... values) {
        return new IntLongObjectTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Long)((Long)values[1])), values[2]);
    }

    public final IntLongObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntLongObjectTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Long)((Long)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntLongObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntLongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntLongObjectTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntLongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull IntLongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntLongObjectTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntLongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        LongChunk chunk2 = chunks[1].asLongChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntLongObjectTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<IntLongObjectTuple, Integer, Long, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<IntLongObjectTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Long> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new IntegerLongObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

