/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.IntShortByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IntegerShortBooleanColumnTupleSource
extends AbstractTupleSource<IntShortByteTuple> {
    public static final ThreeColumnTupleSourceFactory<IntShortByteTuple, Integer, Short, Boolean> FACTORY = new Factory();
    private final ColumnSource<Integer> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Boolean> columnSource3;

    public IntegerShortBooleanColumnTupleSource(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final IntShortByteTuple createTuple(long rowKey) {
        return new IntShortByteTuple(this.columnSource1.getInt(rowKey), this.columnSource2.getShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getBoolean(rowKey)));
    }

    public final IntShortByteTuple createPreviousTuple(long rowKey) {
        return new IntShortByteTuple(this.columnSource1.getPrevInt(rowKey), this.columnSource2.getPrevShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getPrevBoolean(rowKey)));
    }

    public final IntShortByteTuple createTupleFromValues(Object ... values) {
        return new IntShortByteTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Short)((Short)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final IntShortByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new IntShortByteTuple(TypeUtils.unbox((Integer)((Integer)values[0])), TypeUtils.unbox((Short)((Short)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull IntShortByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull IntShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntShortByteTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull IntShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull IntShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((int)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntShortByteTuple tuple) {
        dest[0] = TypeUtils.box((int)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull IntShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((int)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        IntChunk chunk1 = chunks[0].asIntChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new IntShortByteTuple(chunk1.get(ii), chunk2.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<IntShortByteTuple, Integer, Short, Boolean> {
        private Factory() {
        }

        @Override
        public TupleSource<IntShortByteTuple> create(@NotNull ColumnSource<Integer> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
            return new IntegerShortBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

