/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.LongIntDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LongIntegerDoubleColumnTupleSource
extends AbstractTupleSource<LongIntDoubleTuple> {
    public static final ThreeColumnTupleSourceFactory<LongIntDoubleTuple, Long, Integer, Double> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Double> columnSource3;

    public LongIntegerDoubleColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final LongIntDoubleTuple createTuple(long rowKey) {
        return new LongIntDoubleTuple(this.columnSource1.getLong(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.getDouble(rowKey));
    }

    public final LongIntDoubleTuple createPreviousTuple(long rowKey) {
        return new LongIntDoubleTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrevDouble(rowKey));
    }

    public final LongIntDoubleTuple createTupleFromValues(Object ... values) {
        return new LongIntDoubleTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final LongIntDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongIntDoubleTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongIntDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongIntDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongIntDoubleTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongIntDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongIntDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongIntDoubleTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongIntDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        DoubleChunk chunk3 = chunks[2].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongIntDoubleTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<LongIntDoubleTuple, Long, Integer, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<LongIntDoubleTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
            return new LongIntegerDoubleColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

