/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.LongObjectCharTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LongObjectCharacterColumnTupleSource
extends AbstractTupleSource<LongObjectCharTuple> {
    public static final ThreeColumnTupleSourceFactory<LongObjectCharTuple, Long, Object, Character> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Object> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public LongObjectCharacterColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final LongObjectCharTuple createTuple(long rowKey) {
        return new LongObjectCharTuple(this.columnSource1.getLong(rowKey), this.columnSource2.get(rowKey), this.columnSource3.getChar(rowKey));
    }

    public final LongObjectCharTuple createPreviousTuple(long rowKey) {
        return new LongObjectCharTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrev(rowKey), this.columnSource3.getPrevChar(rowKey));
    }

    public final LongObjectCharTuple createTupleFromValues(Object ... values) {
        return new LongObjectCharTuple(TypeUtils.unbox((Long)((Long)values[0])), values[1], TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final LongObjectCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongObjectCharTuple(TypeUtils.unbox((Long)((Long)values[0])), values[1], TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongObjectCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongObjectCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongObjectCharTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongObjectCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongObjectCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongObjectCharTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongObjectCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongObjectCharTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<LongObjectCharTuple, Long, Object, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<LongObjectCharTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new LongObjectCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

