/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.LongShortTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LongShortColumnTupleSource
extends AbstractTupleSource<LongShortTuple> {
    public static final TwoColumnTupleSourceFactory<LongShortTuple, Long, Short> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Short> columnSource2;

    public LongShortColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Short> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final LongShortTuple createTuple(long rowKey) {
        return new LongShortTuple(this.columnSource1.getLong(rowKey), this.columnSource2.getShort(rowKey));
    }

    public final LongShortTuple createPreviousTuple(long rowKey) {
        return new LongShortTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrevShort(rowKey));
    }

    public final LongShortTuple createTupleFromValues(Object ... values) {
        return new LongShortTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Short)((Short)values[1])));
    }

    public final LongShortTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongShortTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Short)((Short)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongShortTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongShortTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongShortTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongShortTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<LongShortTuple, Long, Short> {
        private Factory() {
        }

        @Override
        public TupleSource<LongShortTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Short> columnSource2) {
            return new LongShortColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

