/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectByteObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectByteObjectColumnTupleSource
extends AbstractTupleSource<ObjectByteObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectByteObjectTuple, Object, Byte, Object> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public ObjectByteObjectColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectByteObjectTuple createTuple(long rowKey) {
        return new ObjectByteObjectTuple(this.columnSource1.get(rowKey), this.columnSource2.getByte(rowKey), this.columnSource3.get(rowKey));
    }

    public final ObjectByteObjectTuple createPreviousTuple(long rowKey) {
        return new ObjectByteObjectTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevByte(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final ObjectByteObjectTuple createTupleFromValues(Object ... values) {
        return new ObjectByteObjectTuple(values[0], TypeUtils.unbox((Byte)((Byte)values[1])), values[2]);
    }

    public final ObjectByteObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectByteObjectTuple(values[0], TypeUtils.unbox((Byte)((Byte)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectByteObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectByteObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull ObjectByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectByteObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectByteObjectTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectByteObjectTuple, Object, Byte, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectByteObjectTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new ObjectByteObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

