/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectCharCharTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectCharacterCharacterColumnTupleSource
extends AbstractTupleSource<ObjectCharCharTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectCharCharTuple, Object, Character, Character> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public ObjectCharacterCharacterColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectCharCharTuple createTuple(long rowKey) {
        return new ObjectCharCharTuple(this.columnSource1.get(rowKey), this.columnSource2.getChar(rowKey), this.columnSource3.getChar(rowKey));
    }

    public final ObjectCharCharTuple createPreviousTuple(long rowKey) {
        return new ObjectCharCharTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrevChar(rowKey));
    }

    public final ObjectCharCharTuple createTupleFromValues(Object ... values) {
        return new ObjectCharCharTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final ObjectCharCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectCharCharTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectCharCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectCharCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharCharTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectCharCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharCharTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectCharCharTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectCharCharTuple, Object, Character, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectCharCharTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new ObjectCharacterCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

