/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectCharTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectCharacterColumnTupleSource
extends AbstractTupleSource<ObjectCharTuple> {
    public static final TwoColumnTupleSourceFactory<ObjectCharTuple, Object, Character> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Character> columnSource2;

    public ObjectCharacterColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ObjectCharTuple createTuple(long rowKey) {
        return new ObjectCharTuple(this.columnSource1.get(rowKey), this.columnSource2.getChar(rowKey));
    }

    public final ObjectCharTuple createPreviousTuple(long rowKey) {
        return new ObjectCharTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevChar(rowKey));
    }

    public final ObjectCharTuple createTupleFromValues(Object ... values) {
        return new ObjectCharTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])));
    }

    public final ObjectCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectCharTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectCharTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ObjectCharTuple, Object, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectCharTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2) {
            return new ObjectCharacterColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

