/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectCharIntTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectCharacterIntegerColumnTupleSource
extends AbstractTupleSource<ObjectCharIntTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectCharIntTuple, Object, Character, Integer> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Integer> columnSource3;

    public ObjectCharacterIntegerColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectCharIntTuple createTuple(long rowKey) {
        return new ObjectCharIntTuple(this.columnSource1.get(rowKey), this.columnSource2.getChar(rowKey), this.columnSource3.getInt(rowKey));
    }

    public final ObjectCharIntTuple createPreviousTuple(long rowKey) {
        return new ObjectCharIntTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrevInt(rowKey));
    }

    public final ObjectCharIntTuple createTupleFromValues(Object ... values) {
        return new ObjectCharIntTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final ObjectCharIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectCharIntTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectCharIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectCharIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharIntTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectCharIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharIntTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        IntChunk chunk3 = chunks[2].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectCharIntTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectCharIntTuple, Object, Character, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectCharIntTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
            return new ObjectCharacterIntegerColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

