/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectCharObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectCharacterObjectColumnTupleSource
extends AbstractTupleSource<ObjectCharObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectCharObjectTuple, Object, Character, Object> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public ObjectCharacterObjectColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectCharObjectTuple createTuple(long rowKey) {
        return new ObjectCharObjectTuple(this.columnSource1.get(rowKey), this.columnSource2.getChar(rowKey), this.columnSource3.get(rowKey));
    }

    public final ObjectCharObjectTuple createPreviousTuple(long rowKey) {
        return new ObjectCharObjectTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final ObjectCharObjectTuple createTupleFromValues(Object ... values) {
        return new ObjectCharObjectTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), values[2]);
    }

    public final ObjectCharObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectCharObjectTuple(values[0], TypeUtils.unbox((Character)((Character)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectCharObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectCharObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectCharObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull ObjectCharObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectCharObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectCharObjectTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectCharObjectTuple, Object, Character, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectCharObjectTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new ObjectCharacterObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

