/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectDoubleColumnTupleSource
extends AbstractTupleSource<ObjectDoubleTuple> {
    public static final TwoColumnTupleSourceFactory<ObjectDoubleTuple, Object, Double> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Double> columnSource2;

    public ObjectDoubleColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ObjectDoubleTuple createTuple(long rowKey) {
        return new ObjectDoubleTuple(this.columnSource1.get(rowKey), this.columnSource2.getDouble(rowKey));
    }

    public final ObjectDoubleTuple createPreviousTuple(long rowKey) {
        return new ObjectDoubleTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevDouble(rowKey));
    }

    public final ObjectDoubleTuple createTupleFromValues(Object ... values) {
        return new ObjectDoubleTuple(values[0], TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final ObjectDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectDoubleTuple(values[0], TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectDoubleTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectDoubleTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectDoubleTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ObjectDoubleTuple, Object, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectDoubleTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
            return new ObjectDoubleColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

