/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ObjectLongObjectTuple;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ObjectInstantObjectColumnTupleSource
extends AbstractTupleSource<ObjectLongObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectLongObjectTuple, Object, Instant, Object> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Instant> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public ObjectInstantObjectColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectLongObjectTuple createTuple(long rowKey) {
        return new ObjectLongObjectTuple(this.columnSource1.get(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.get(rowKey))), this.columnSource3.get(rowKey));
    }

    public final ObjectLongObjectTuple createPreviousTuple(long rowKey) {
        return new ObjectLongObjectTuple(this.columnSource1.getPrev(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.getPrev(rowKey))), this.columnSource3.getPrev(rowKey));
    }

    public final ObjectLongObjectTuple createTupleFromValues(Object ... values) {
        return new ObjectLongObjectTuple(values[0], DateTimeUtils.epochNanos((Instant)((Instant)values[1])), values[2]);
    }

    public final ObjectLongObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectLongObjectTuple(values[0], DateTimeUtils.epochNanos((Instant)((Instant)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectLongObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectLongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectLongObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectLongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull ObjectLongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectLongObjectTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectLongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectLongObjectTuple(chunk1.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectLongObjectTuple, Object, Instant, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectLongObjectTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new ObjectInstantObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

