/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ObjectByteLongTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ObjectReinterpretedBooleanInstantColumnTupleSource
extends AbstractTupleSource<ObjectByteLongTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectByteLongTuple, Object, Byte, Instant> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Byte> columnSource2;
    private final ColumnSource<Instant> columnSource3;

    public ObjectReinterpretedBooleanInstantColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectByteLongTuple createTuple(long rowKey) {
        return new ObjectByteLongTuple(this.columnSource1.get(rowKey), this.columnSource2.getByte(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.get(rowKey))));
    }

    public final ObjectByteLongTuple createPreviousTuple(long rowKey) {
        return new ObjectByteLongTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevByte(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.getPrev(rowKey))));
    }

    public final ObjectByteLongTuple createTupleFromValues(Object ... values) {
        return new ObjectByteLongTuple(values[0], BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final ObjectByteLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectByteLongTuple(values[0], TypeUtils.unbox((Byte)((Byte)values[1])), DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectByteLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectByteLongTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectByteLongTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectByteLongTuple(chunk1.get(ii), chunk2.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectByteLongTuple, Object, Byte, Instant> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectByteLongTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Byte> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
            return new ObjectReinterpretedBooleanInstantColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

