/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ObjectShortDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectShortDoubleColumnTupleSource
extends AbstractTupleSource<ObjectShortDoubleTuple> {
    public static final ThreeColumnTupleSourceFactory<ObjectShortDoubleTuple, Object, Short, Double> FACTORY = new Factory();
    private final ColumnSource<Object> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Double> columnSource3;

    public ObjectShortDoubleColumnTupleSource(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ObjectShortDoubleTuple createTuple(long rowKey) {
        return new ObjectShortDoubleTuple(this.columnSource1.get(rowKey), this.columnSource2.getShort(rowKey), this.columnSource3.getDouble(rowKey));
    }

    public final ObjectShortDoubleTuple createPreviousTuple(long rowKey) {
        return new ObjectShortDoubleTuple(this.columnSource1.getPrev(rowKey), this.columnSource2.getPrevShort(rowKey), this.columnSource3.getPrevDouble(rowKey));
    }

    public final ObjectShortDoubleTuple createTupleFromValues(Object ... values) {
        return new ObjectShortDoubleTuple(values[0], TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final ObjectShortDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ObjectShortDoubleTuple(values[0], TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ObjectShortDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ObjectShortDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectShortDoubleTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ObjectShortDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ObjectShortDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return tuple.getFirstElement();
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectShortDoubleTuple tuple) {
        dest[0] = tuple.getFirstElement();
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ObjectShortDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = tuple.getFirstElement();
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        DoubleChunk chunk3 = chunks[2].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ObjectShortDoubleTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ObjectShortDoubleTuple, Object, Short, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<ObjectShortDoubleTuple> create(@NotNull ColumnSource<Object> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
            return new ObjectShortDoubleColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

