/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteObjectTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedBooleanObjectColumnTupleSource
extends AbstractTupleSource<ByteObjectTuple> {
    public static final TwoColumnTupleSourceFactory<ByteObjectTuple, Byte, Object> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Object> columnSource2;

    public ReinterpretedBooleanObjectColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ByteObjectTuple createTuple(long rowKey) {
        return new ByteObjectTuple(this.columnSource1.getByte(rowKey), this.columnSource2.get(rowKey));
    }

    public final ByteObjectTuple createPreviousTuple(long rowKey) {
        return new ByteObjectTuple(this.columnSource1.getPrevByte(rowKey), this.columnSource2.getPrev(rowKey));
    }

    public final ByteObjectTuple createTupleFromValues(Object ... values) {
        return new ByteObjectTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), values[1]);
    }

    public final ByteObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteObjectTuple(TypeUtils.unbox((Byte)((Byte)values[0])), values[1]);
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    public final Object exportElementReinterpreted(@NotNull ByteObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteObjectTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ByteObjectTuple, Byte, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteObjectTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
            return new ReinterpretedBooleanObjectColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

