/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteShortByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedBooleanShortBooleanColumnTupleSource
extends AbstractTupleSource<ByteShortByteTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteShortByteTuple, Byte, Short, Boolean> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Boolean> columnSource3;

    public ReinterpretedBooleanShortBooleanColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteShortByteTuple createTuple(long rowKey) {
        return new ByteShortByteTuple(this.columnSource1.getByte(rowKey), this.columnSource2.getShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getBoolean(rowKey)));
    }

    public final ByteShortByteTuple createPreviousTuple(long rowKey) {
        return new ByteShortByteTuple(this.columnSource1.getPrevByte(rowKey), this.columnSource2.getPrevShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getPrevBoolean(rowKey)));
    }

    public final ByteShortByteTuple createTupleFromValues(Object ... values) {
        return new ByteShortByteTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Short)((Short)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final ByteShortByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteShortByteTuple(TypeUtils.unbox((Byte)((Byte)values[0])), TypeUtils.unbox((Short)((Short)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteShortByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteShortByteTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteShortByteTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteShortByteTuple(chunk1.get(ii), chunk2.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteShortByteTuple, Byte, Short, Boolean> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteShortByteTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
            return new ReinterpretedBooleanShortBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

