/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteShortCharTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedBooleanShortCharacterColumnTupleSource
extends AbstractTupleSource<ByteShortCharTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteShortCharTuple, Byte, Short, Character> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public ReinterpretedBooleanShortCharacterColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteShortCharTuple createTuple(long rowKey) {
        return new ByteShortCharTuple(this.columnSource1.getByte(rowKey), this.columnSource2.getShort(rowKey), this.columnSource3.getChar(rowKey));
    }

    public final ByteShortCharTuple createPreviousTuple(long rowKey) {
        return new ByteShortCharTuple(this.columnSource1.getPrevByte(rowKey), this.columnSource2.getPrevShort(rowKey), this.columnSource3.getPrevChar(rowKey));
    }

    public final ByteShortCharTuple createTupleFromValues(Object ... values) {
        return new ByteShortCharTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final ByteShortCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteShortCharTuple(TypeUtils.unbox((Byte)((Byte)values[0])), TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteShortCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteShortCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteShortCharTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteShortCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteShortCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteShortCharTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteShortCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteShortCharTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteShortCharTuple, Byte, Short, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteShortCharTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new ReinterpretedBooleanShortCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

