/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.LongDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedInstantDoubleColumnTupleSource
extends AbstractTupleSource<LongDoubleTuple> {
    public static final TwoColumnTupleSourceFactory<LongDoubleTuple, Long, Double> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Double> columnSource2;

    public ReinterpretedInstantDoubleColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final LongDoubleTuple createTuple(long rowKey) {
        return new LongDoubleTuple(this.columnSource1.getLong(rowKey), this.columnSource2.getDouble(rowKey));
    }

    public final LongDoubleTuple createPreviousTuple(long rowKey) {
        return new LongDoubleTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrevDouble(rowKey));
    }

    public final LongDoubleTuple createTupleFromValues(Object ... values) {
        return new LongDoubleTuple(DateTimeUtils.epochNanos((Instant)((Instant)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final LongDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongDoubleTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongDoubleTuple tuple) {
        dest[0] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongDoubleTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongDoubleTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<LongDoubleTuple, Long, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<LongDoubleTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
            return new ReinterpretedInstantDoubleColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

