/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.LongIntTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedInstantIntegerColumnTupleSource
extends AbstractTupleSource<LongIntTuple> {
    public static final TwoColumnTupleSourceFactory<LongIntTuple, Long, Integer> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Integer> columnSource2;

    public ReinterpretedInstantIntegerColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final LongIntTuple createTuple(long rowKey) {
        return new LongIntTuple(this.columnSource1.getLong(rowKey), this.columnSource2.getInt(rowKey));
    }

    public final LongIntTuple createPreviousTuple(long rowKey) {
        return new LongIntTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrevInt(rowKey));
    }

    public final LongIntTuple createTupleFromValues(Object ... values) {
        return new LongIntTuple(DateTimeUtils.epochNanos((Instant)((Instant)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final LongIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongIntTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongIntTuple tuple) {
        dest[0] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongIntTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongIntTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<LongIntTuple, Long, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<LongIntTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
            return new ReinterpretedInstantIntegerColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

