/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.LongObjectTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedInstantObjectColumnTupleSource
extends AbstractTupleSource<LongObjectTuple> {
    public static final TwoColumnTupleSourceFactory<LongObjectTuple, Long, Object> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Object> columnSource2;

    public ReinterpretedInstantObjectColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final LongObjectTuple createTuple(long rowKey) {
        return new LongObjectTuple(this.columnSource1.getLong(rowKey), this.columnSource2.get(rowKey));
    }

    public final LongObjectTuple createPreviousTuple(long rowKey) {
        return new LongObjectTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrev(rowKey));
    }

    public final LongObjectTuple createTupleFromValues(Object ... values) {
        return new LongObjectTuple(DateTimeUtils.epochNanos((Instant)((Instant)values[0])), values[1]);
    }

    public final LongObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongObjectTuple(TypeUtils.unbox((Long)((Long)values[0])), values[1]);
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongObjectTuple tuple) {
        dest[0] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    public final Object exportElementReinterpreted(@NotNull LongObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongObjectTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongObjectTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<LongObjectTuple, Long, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<LongObjectTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
            return new ReinterpretedInstantObjectColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

