/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.LongShortFloatTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ReinterpretedInstantShortFloatColumnTupleSource
extends AbstractTupleSource<LongShortFloatTuple> {
    public static final ThreeColumnTupleSourceFactory<LongShortFloatTuple, Long, Short, Float> FACTORY = new Factory();
    private final ColumnSource<Long> columnSource1;
    private final ColumnSource<Short> columnSource2;
    private final ColumnSource<Float> columnSource3;

    public ReinterpretedInstantShortFloatColumnTupleSource(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final LongShortFloatTuple createTuple(long rowKey) {
        return new LongShortFloatTuple(this.columnSource1.getLong(rowKey), this.columnSource2.getShort(rowKey), this.columnSource3.getFloat(rowKey));
    }

    public final LongShortFloatTuple createPreviousTuple(long rowKey) {
        return new LongShortFloatTuple(this.columnSource1.getPrevLong(rowKey), this.columnSource2.getPrevShort(rowKey), this.columnSource3.getPrevFloat(rowKey));
    }

    public final LongShortFloatTuple createTupleFromValues(Object ... values) {
        return new LongShortFloatTuple(DateTimeUtils.epochNanos((Instant)((Instant)values[0])), TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final LongShortFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new LongShortFloatTuple(TypeUtils.unbox((Long)((Long)values[0])), TypeUtils.unbox((Short)((Short)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull LongShortFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull LongShortFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongShortFloatTuple tuple) {
        dest[0] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull LongShortFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = DateTimeUtils.epochNanosToInstant((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull LongShortFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((long)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((short)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongShortFloatTuple tuple) {
        dest[0] = TypeUtils.box((long)tuple.getFirstElement());
        dest[1] = TypeUtils.box((short)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull LongShortFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((long)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((short)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        LongChunk chunk1 = chunks[0].asLongChunk();
        ShortChunk chunk2 = chunks[1].asShortChunk();
        FloatChunk chunk3 = chunks[2].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new LongShortFloatTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<LongShortFloatTuple, Long, Short, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<LongShortFloatTuple> create(@NotNull ColumnSource<Long> columnSource1, @NotNull ColumnSource<Short> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
            return new ReinterpretedInstantShortFloatColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

