/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ShortByteLongTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ShortBooleanLongColumnTupleSource
extends AbstractTupleSource<ShortByteLongTuple> {
    public static final ThreeColumnTupleSourceFactory<ShortByteLongTuple, Short, Boolean, Long> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Boolean> columnSource2;
    private final ColumnSource<Long> columnSource3;

    public ShortBooleanLongColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ShortByteLongTuple createTuple(long rowKey) {
        return new ShortByteLongTuple(this.columnSource1.getShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getBoolean(rowKey)), this.columnSource3.getLong(rowKey));
    }

    public final ShortByteLongTuple createPreviousTuple(long rowKey) {
        return new ShortByteLongTuple(this.columnSource1.getPrevShort(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getPrevBoolean(rowKey)), this.columnSource3.getPrevLong(rowKey));
    }

    public final ShortByteLongTuple createTupleFromValues(Object ... values) {
        return new ShortByteLongTuple(TypeUtils.unbox((Short)((Short)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Long)((Long)values[2])));
    }

    public final ShortByteLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortByteLongTuple(TypeUtils.unbox((Short)((Short)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Long)((Long)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortByteLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortByteLongTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortByteLongTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        LongChunk chunk3 = chunks[2].asLongChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortByteLongTuple(chunk1.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ShortByteLongTuple, Short, Boolean, Long> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortByteLongTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
            return new ShortBooleanLongColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

