/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ShortDoubleByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ShortDoubleBooleanColumnTupleSource
extends AbstractTupleSource<ShortDoubleByteTuple> {
    public static final ThreeColumnTupleSourceFactory<ShortDoubleByteTuple, Short, Double, Boolean> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Double> columnSource2;
    private final ColumnSource<Boolean> columnSource3;

    public ShortDoubleBooleanColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Double> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ShortDoubleByteTuple createTuple(long rowKey) {
        return new ShortDoubleByteTuple(this.columnSource1.getShort(rowKey), this.columnSource2.getDouble(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getBoolean(rowKey)));
    }

    public final ShortDoubleByteTuple createPreviousTuple(long rowKey) {
        return new ShortDoubleByteTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrevDouble(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource3.getPrevBoolean(rowKey)));
    }

    public final ShortDoubleByteTuple createTupleFromValues(Object ... values) {
        return new ShortDoubleByteTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Double)((Double)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final ShortDoubleByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortDoubleByteTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Double)((Double)values[1])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortDoubleByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortDoubleByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortDoubleByteTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortDoubleByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortDoubleByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortDoubleByteTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
        dest[2] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortDoubleByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
        dest[map[2]] = BooleanUtils.byteAsBoolean((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortDoubleByteTuple(chunk1.get(ii), chunk2.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ShortDoubleByteTuple, Short, Double, Boolean> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortDoubleByteTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Double> columnSource2, @NotNull ColumnSource<Boolean> columnSource3) {
            return new ShortDoubleBooleanColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

