/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ShortDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ShortDoubleColumnTupleSource
extends AbstractTupleSource<ShortDoubleTuple> {
    public static final TwoColumnTupleSourceFactory<ShortDoubleTuple, Short, Double> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Double> columnSource2;

    public ShortDoubleColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ShortDoubleTuple createTuple(long rowKey) {
        return new ShortDoubleTuple(this.columnSource1.getShort(rowKey), this.columnSource2.getDouble(rowKey));
    }

    public final ShortDoubleTuple createPreviousTuple(long rowKey) {
        return new ShortDoubleTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrevDouble(rowKey));
    }

    public final ShortDoubleTuple createTupleFromValues(Object ... values) {
        return new ShortDoubleTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final ShortDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortDoubleTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortDoubleTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortDoubleTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortDoubleTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ShortDoubleTuple, Short, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortDoubleTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
            return new ShortDoubleColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

