/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ShortIntIntTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ShortIntegerIntegerColumnTupleSource
extends AbstractTupleSource<ShortIntIntTuple> {
    public static final ThreeColumnTupleSourceFactory<ShortIntIntTuple, Short, Integer, Integer> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Integer> columnSource3;

    public ShortIntegerIntegerColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ShortIntIntTuple createTuple(long rowKey) {
        return new ShortIntIntTuple(this.columnSource1.getShort(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.getInt(rowKey));
    }

    public final ShortIntIntTuple createPreviousTuple(long rowKey) {
        return new ShortIntIntTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrevInt(rowKey));
    }

    public final ShortIntIntTuple createTupleFromValues(Object ... values) {
        return new ShortIntIntTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final ShortIntIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortIntIntTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortIntIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortIntIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortIntIntTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortIntIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortIntIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortIntIntTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortIntIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        IntChunk chunk3 = chunks[2].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortIntIntTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ShortIntIntTuple, Short, Integer, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortIntIntTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
            return new ShortIntegerIntegerColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

