/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ShortObjectLongTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ShortObjectInstantColumnTupleSource
extends AbstractTupleSource<ShortObjectLongTuple> {
    public static final ThreeColumnTupleSourceFactory<ShortObjectLongTuple, Short, Object, Instant> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Object> columnSource2;
    private final ColumnSource<Instant> columnSource3;

    public ShortObjectInstantColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ShortObjectLongTuple createTuple(long rowKey) {
        return new ShortObjectLongTuple(this.columnSource1.getShort(rowKey), this.columnSource2.get(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.get(rowKey))));
    }

    public final ShortObjectLongTuple createPreviousTuple(long rowKey) {
        return new ShortObjectLongTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrev(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource3.getPrev(rowKey))));
    }

    public final ShortObjectLongTuple createTupleFromValues(Object ... values) {
        return new ShortObjectLongTuple(TypeUtils.unbox((Short)((Short)values[0])), values[1], DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final ShortObjectLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortObjectLongTuple(TypeUtils.unbox((Short)((Short)values[0])), values[1], DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortObjectLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortObjectLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortObjectLongTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortObjectLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortObjectLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortObjectLongTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortObjectLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortObjectLongTuple(chunk1.get(ii), chunk2.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk3.get(ii)))));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ShortObjectLongTuple, Short, Object, Instant> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortObjectLongTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Instant> columnSource3) {
            return new ShortObjectInstantColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

