/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ShortByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ShortReinterpretedBooleanColumnTupleSource
extends AbstractTupleSource<ShortByteTuple> {
    public static final TwoColumnTupleSourceFactory<ShortByteTuple, Short, Byte> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Byte> columnSource2;

    public ShortReinterpretedBooleanColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Byte> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ShortByteTuple createTuple(long rowKey) {
        return new ShortByteTuple(this.columnSource1.getShort(rowKey), this.columnSource2.getByte(rowKey));
    }

    public final ShortByteTuple createPreviousTuple(long rowKey) {
        return new ShortByteTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrevByte(rowKey));
    }

    public final ShortByteTuple createTupleFromValues(Object ... values) {
        return new ShortByteTuple(TypeUtils.unbox((Short)((Short)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])));
    }

    public final ShortByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortByteTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Byte)((Byte)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortByteTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((byte)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        ByteChunk chunk2 = chunks[1].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortByteTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortByteTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((byte)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ShortByteTuple, Short, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortByteTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Byte> columnSource2) {
            return new ShortReinterpretedBooleanColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

