/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ShortLongIntTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ShortReinterpretedInstantIntegerColumnTupleSource
extends AbstractTupleSource<ShortLongIntTuple> {
    public static final ThreeColumnTupleSourceFactory<ShortLongIntTuple, Short, Long, Integer> FACTORY = new Factory();
    private final ColumnSource<Short> columnSource1;
    private final ColumnSource<Long> columnSource2;
    private final ColumnSource<Integer> columnSource3;

    public ShortReinterpretedInstantIntegerColumnTupleSource(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Long> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ShortLongIntTuple createTuple(long rowKey) {
        return new ShortLongIntTuple(this.columnSource1.getShort(rowKey), this.columnSource2.getLong(rowKey), this.columnSource3.getInt(rowKey));
    }

    public final ShortLongIntTuple createPreviousTuple(long rowKey) {
        return new ShortLongIntTuple(this.columnSource1.getPrevShort(rowKey), this.columnSource2.getPrevLong(rowKey), this.columnSource3.getPrevInt(rowKey));
    }

    public final ShortLongIntTuple createTupleFromValues(Object ... values) {
        return new ShortLongIntTuple(TypeUtils.unbox((Short)((Short)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final ShortLongIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ShortLongIntTuple(TypeUtils.unbox((Short)((Short)values[0])), TypeUtils.unbox((Long)((Long)values[1])), TypeUtils.unbox((Integer)((Integer)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ShortLongIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ShortLongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortLongIntTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ShortLongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ShortLongIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((short)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((int)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortLongIntTuple tuple) {
        dest[0] = TypeUtils.box((short)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((int)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ShortLongIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((short)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((int)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ShortChunk chunk1 = chunks[0].asShortChunk();
        LongChunk chunk2 = chunks[1].asLongChunk();
        IntChunk chunk3 = chunks[2].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ShortLongIntTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ShortLongIntTuple, Short, Long, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<ShortLongIntTuple> create(@NotNull ColumnSource<Short> columnSource1, @NotNull ColumnSource<Long> columnSource2, @NotNull ColumnSource<Integer> columnSource3) {
            return new ShortReinterpretedInstantIntegerColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

