/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.engine.liveness.RetainedReferenceTracker;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.HeapDump;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class Liveness {
    public static final Logger log = LoggerFactory.getLogger(Liveness.class);
    static final boolean REFERENCE_TRACKING_DISABLED = Configuration.getInstance().getBooleanWithDefault("Liveness.referenceTrackingDisabled", false);
    public static final boolean DEBUG_MODE_ENABLED = Configuration.getInstance().getBooleanWithDefault("Liveness.debugModeEnabled", false);
    private static final boolean COUNT_LOG_ENABLED = Configuration.getInstance().getBooleanWithDefault("Liveness.countLogEnabled", true);
    private static final boolean HEAP_DUMP_ENABLED = Configuration.getInstance().getBooleanWithDefault("Liveness.heapDump", false);
    static final boolean CLEANUP_LOG_ENABLED = Configuration.getInstance().getBooleanWithDefault("Liveness.cleanupLogEnabled", false);
    private static final long OUTSTANDING_COUNT_LOG_INTERVAL_MILLIS = 1000L;
    private static boolean outstandingCountChanged = true;
    private static int intervalLastOutstandingCount = 0;
    private static int intervalMinOutstandingCount = 0;
    private static int intervalMaxOutstandingCount = 0;

    private static void maybeLogOutstandingCount() {
        if (!COUNT_LOG_ENABLED) {
            return;
        }
        int outstandingCount = RetainedReferenceTracker.getOutstandingCount();
        if (outstandingCount != intervalLastOutstandingCount) {
            outstandingCountChanged = true;
        }
        intervalMinOutstandingCount = Math.min(outstandingCount, intervalMinOutstandingCount);
        intervalMaxOutstandingCount = Math.max(outstandingCount, intervalMaxOutstandingCount);
        if (!outstandingCountChanged) {
            return;
        }
        log.info().append((CharSequence)"Liveness: Outstanding count=").append(outstandingCount).append((CharSequence)", intervalMin=").append(intervalMinOutstandingCount).append((CharSequence)", intervalMax=").append(intervalMaxOutstandingCount).endl();
        outstandingCountChanged = false;
        intervalMinOutstandingCount = intervalMaxOutstandingCount = outstandingCount;
        intervalLastOutstandingCount = intervalMaxOutstandingCount;
    }

    public static ScheduledFuture<?> scheduleCountReport(@NotNull ScheduledExecutorService scheduler) {
        return scheduler.scheduleAtFixedRate(Liveness::maybeLogOutstandingCount, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private Liveness() {
    }

    public static boolean verifyCachedObjectForReuse(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LivenessReferent)) {
            return true;
        }
        if (DynamicNode.isDynamicAndNotRefreshing(object)) {
            return true;
        }
        return LivenessScopeStack.peek().tryManage((LivenessReferent)object);
    }

    static void maybeHeapDump(LivenessStateException lse) {
        if (!HEAP_DUMP_ENABLED) {
            return;
        }
        String heapDumpPath = HeapDump.generateHeapDumpPath();
        log.fatal().append((CharSequence)"LivenessStateException, generating heap dump to").append((CharSequence)heapDumpPath).append((CharSequence)": ").append((Throwable)lse).endl();
        try {
            HeapDump.heapDump((String)heapDumpPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

