/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.LivenessManager;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.util.annotations.FinalDefault;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface LivenessNode
extends LivenessReferent,
LivenessManager {
    @FinalDefault
    default public void unmanage(@NotNull LivenessReferent referent) {
        if (!this.tryUnmanage(referent)) {
            throw new LivenessStateException(this + " is no longer live and cannot unmanage " + referent.getReferentDescription());
        }
    }

    public boolean tryUnmanage(@NotNull LivenessReferent var1);

    @FinalDefault
    default public void unmanage(@NotNull Stream<? extends LivenessReferent> referents) {
        if (!this.tryUnmanage(referents)) {
            throw new LivenessStateException(this + " is no longer live and cannot unmanage " + referents.map(LivenessReferent::getReferentDescription).collect(Collectors.joining()));
        }
    }

    public boolean tryUnmanage(@NotNull Stream<? extends LivenessReferent> var1);
}

